using System.Xml;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents heartbeat request message as 
	/// defined in VistALink protocol specification.
	/// </summary>
	public sealed class VistALinkHeartbeatRequestMessage : VistALinkSimpleRequestMessage, IPingMessage
	{
		/// <summary>
		/// VistALink message request type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string RequestType = "heartbeat"; 

		/// <summary>
		/// Constructor specifying minimal required VistALink 
		/// heartbeat request message parameters. 
		/// </summary>
		public VistALinkHeartbeatRequestMessage() 
			: base( RequestType ){} 

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document</param>
		public VistALinkHeartbeatRequestMessage( XmlDocument sourceDoc ) 
			: base( RequestType, sourceDoc ){} 
	}
}
